﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Tests
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Net.Mail;
    using Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Notifications;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass]
    public class NotificationServiceFixture
    {
        [TestMethod]
        [DeploymentItem("Notifications\\MailTestTemplate_TXT.txt")]
        public void SendMailAsText()
        {
            MailMessage sentMail = null;

            var reader = new Mock<ITemplateReader>();
            reader.Setup(o => o.RetrieveTemplate("test_htm"))
                  .Returns(File.ReadAllText(Path.Combine(Environment.CurrentDirectory, "MailTestTemplate_TXT.txt")));

            var mailer = new Mock<IMailer>();
            mailer.Setup(o => o.SendMail(It.IsAny<MailMessage>()))
                  .Callback<MailMessage>((m) => sentMail = m)
                  .Returns(true);

            var notifier = new NotificationService(mailer.Object, reader.Object);

            var fields = new Dictionary<string, string> {
                { "field1", "Hello World" },
                { "field2", "Lorem Ipsum" },
                { "field3", "End Of Message" }
            };

            notifier.SendMail("test_htm", new MailAddress("test@sender.net"), new MailAddress("user@test.com"), fields);

            reader.VerifyAll();
            mailer.VerifyAll();
            Assert.IsNotNull(sentMail);
            Assert.IsFalse(sentMail.IsBodyHtml);
            Assert.AreEqual("test@sender.net", sentMail.From.Address);
            Assert.AreEqual("user@test.com", sentMail.To[0].Address);
            Assert.AreEqual("PlanMyNight - Test Subject", sentMail.Subject);
            Assert.IsTrue(sentMail.Body.Contains("Hello World"));
            Assert.IsTrue(sentMail.Body.Contains("Lorem Ipsum"));
            Assert.IsTrue(sentMail.Body.Contains("End Of Message"));
        }

        [TestMethod]
        [DeploymentItem("Notifications\\MailTestTemplate_HTM.txt")]
        public void SendMailAsHtml()
        {
            MailMessage sentMail = null;

            var reader = new Mock<ITemplateReader>();
            reader.Setup(o => o.RetrieveTemplate("test_txt"))
                  .Returns(File.ReadAllText(Path.Combine(Environment.CurrentDirectory, "MailTestTemplate_HTM.txt")));

            var mailer = new Mock<IMailer>();
            mailer.Setup(o => o.SendMail(It.IsAny<MailMessage>()))
                  .Callback<MailMessage>((m) => sentMail = m)
                  .Returns(true);

            var notifier = new NotificationService(mailer.Object, reader.Object);

            var fields = new Dictionary<string, string> {
                { "field1", "Hello World" },
                { "field2", "Lorem Ipsum" },
                { "field3", "End Of Message" }
            };

            notifier.SendMail("test_txt", new MailAddress("test@sender.net"), new MailAddress("user@test.com"), fields);

            reader.VerifyAll();
            mailer.VerifyAll();
            Assert.IsNotNull(sentMail);
            Assert.IsTrue(sentMail.IsBodyHtml);
            Assert.AreEqual("test@sender.net", sentMail.From.Address);
            Assert.AreEqual("user@test.com", sentMail.To[0].Address);
            Assert.AreEqual("PlanMyNight - Test Subject", sentMail.Subject);
            Assert.IsTrue(sentMail.Body.Contains("Hello World"));
            Assert.IsTrue(sentMail.Body.Contains("Lorem Ipsum"));
            Assert.IsTrue(sentMail.Body.Contains("End Of Message"));
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentOutOfRangeException))]
        public void SendMailWithUnexistingTemplateFails()
        {
            var reader = new Mock<ITemplateReader>();
            reader.Setup(o => o.RetrieveTemplate("xxxxx")).Returns(default(string));

            var mailer = new Mock<IMailer>();
            var notifier = new NotificationService(mailer.Object, reader.Object);
            notifier.SendMail("xxxxx", new MailAddress("test@sender.net"), new MailAddress("user@test.com"), new Dictionary<string, string>());
        }
    }
}
